/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class DMobile
extends MIDlet
implements Runnable,
CommandListener {
    private Display display;
    private ChatCanvas canvas;
    private TextBox inputBox;
    private Command sendCmd;
    private Command exitCmd;
    private Command backCmd;
    private Form mainMenu;
    private Command connectCmd;
    private Command settingsCmd;
    private Form settingsForm;
    private TextField serverField;
    private TextField portField;
    private TextField usernameField;
    private TextField passwordField;
    private Command saveSettingsCmd;
    private Command cancelSettingsCmd;
    private Command exitAppCmd;
    private SocketConnection sc;
    private InputStream is;
    private OutputStream os;
    private Thread listenerThread;
    private boolean connected = false;
    private boolean running = true;
    private Vector messages = new Vector();
    private String serverAddress = "147.185.221.19";
    private int serverPort = 42439;
    private String username = "";
    private String password = "";
    private Displayable currentScreen = null;
    private StringBuffer recvBuffer = new StringBuffer();

    public DMobile() {
        this.display = Display.getDisplay((MIDlet)this);
        this.mainMenu = new Form("DMconnect");
        this.mainMenu.append("DMconnect client for J2ME. Created by BitByByte on 18.09.2025.\nhttp://dmconnect.w10.site/");
        this.connectCmd = new Command("Connect", 4, 1);
        this.settingsCmd = new Command("Settings", 1, 2);
        this.exitAppCmd = new Command("Exit", 7, 3);
        this.mainMenu.addCommand(this.connectCmd);
        this.mainMenu.addCommand(this.settingsCmd);
        this.mainMenu.addCommand(this.exitAppCmd);
        this.mainMenu.setCommandListener((CommandListener)this);
        this.settingsForm = new Form("Settings");
        this.serverField = new TextField("Server", this.serverAddress, 64, 0);
        this.portField = new TextField("Port", Integer.toString(this.serverPort), 6, 2);
        this.usernameField = new TextField("Username", this.username, 32, 0);
        this.passwordField = new TextField("Password", this.password, 32, 65536);
        this.settingsForm.append((Item)this.serverField);
        this.settingsForm.append((Item)this.portField);
        this.settingsForm.append((Item)this.usernameField);
        this.settingsForm.append((Item)this.passwordField);
        this.saveSettingsCmd = new Command("Save", 4, 1);
        this.cancelSettingsCmd = new Command("Cancel", 3, 2);
        this.settingsForm.addCommand(this.saveSettingsCmd);
        this.settingsForm.addCommand(this.cancelSettingsCmd);
        this.settingsForm.setCommandListener((CommandListener)this);
        this.exitCmd = new Command("Exit", 7, 2);
        this.canvas = new ChatCanvas();
        Command canvasSendCmd = new Command("Send", 4, 1);
        this.canvas.addCommand(this.exitCmd);
        this.canvas.addCommand(canvasSendCmd);
        this.canvas.setCommandListener(this);
        this.sendCmd = new Command("Send", 4, 2);
        this.backCmd = new Command("Back", 2, 1);
        this.inputBox = new TextBox("Message", " ", 128, 524288);
        this.inputBox.addCommand(this.backCmd);
        this.inputBox.addCommand(this.sendCmd);
        this.inputBox.setCommandListener((CommandListener)this);
    }

    public void startApp() {
        this.loadSettings();
        if (this.currentScreen == null) {
            this.display.setCurrent((Displayable)this.mainMenu);
            this.currentScreen = this.mainMenu;
        } else {
            this.display.setCurrent(this.currentScreen);
        }
    }

    private void setCurrentScreen(Displayable d) {
        this.display.setCurrent(d);
        this.currentScreen = d;
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        this.running = false;
        this.disconnect();
        this.saveSettings();
    }

    public void commandAction(Command c, Displayable d) {
        if (d == this.mainMenu) {
            if (c == this.connectCmd) {
                this.connect();
                this.setCurrentScreen((Displayable)this.canvas);
            } else if (c == this.settingsCmd) {
                this.serverField.setString(this.serverAddress);
                this.portField.setString(Integer.toString(this.serverPort));
                this.usernameField.setString(this.username);
                this.passwordField.setString(this.password);
                this.setCurrentScreen((Displayable)this.settingsForm);
            } else if (c == this.exitAppCmd) {
                this.saveSettings();
                this.destroyApp(true);
                this.notifyDestroyed();
            }
        } else if (d == this.settingsForm) {
            if (c == this.saveSettingsCmd) {
                this.serverAddress = this.serverField.getString().trim();
                try {
                    this.serverPort = Integer.parseInt(this.portField.getString().trim());
                }
                catch (NumberFormatException e) {
                    this.serverPort = 42439;
                }
                this.username = this.usernameField.getString().trim();
                this.password = this.passwordField.getString().trim();
                this.saveSettings();
                this.setCurrentScreen((Displayable)this.mainMenu);
            } else if (c == this.cancelSettingsCmd) {
                this.setCurrentScreen((Displayable)this.mainMenu);
            }
        } else if (d == this.canvas) {
            if (c.getLabel().equals("Send")) {
                this.setCurrentScreen((Displayable)this.inputBox);
            } else if (c == this.exitCmd) {
                this.disconnect();
                this.setCurrentScreen((Displayable)this.mainMenu);
            }
        } else if (d == this.inputBox) {
            if (c == this.sendCmd) {
                String msg = this.inputBox.getString();
                if (msg != null && msg.startsWith(" ")) {
                    msg = msg.substring(1);
                }
                if (msg != null && msg.length() > 0 && this.connected) {
                    if (msg.startsWith("/login ")) {
                        int firstSpace = msg.indexOf(32);
                        int secondSpace = msg.indexOf(32, firstSpace + 1);
                        if (firstSpace > 0 && secondSpace > firstSpace) {
                            this.username = msg.substring(firstSpace + 1, secondSpace);
                            this.password = msg.substring(secondSpace + 1);
                            this.usernameField.setString(this.username);
                            this.passwordField.setString(this.password);
                        }
                    }
                    this.sendMessage(msg);
                }
                this.inputBox.setString(" ");
                this.setCurrentScreen((Displayable)this.canvas);
            } else if (c == this.backCmd) {
                this.inputBox.setString(" ");
                this.setCurrentScreen((Displayable)this.canvas);
            }
        }
    }

    private void connect() {
        try {
            this.sc = (SocketConnection)Connector.open((String)("socket://" + this.serverAddress + ":" + this.serverPort));
            this.is = this.sc.openInputStream();
            this.os = this.sc.openOutputStream();
            this.connected = true;
            this.listenerThread = new Thread(this);
            this.listenerThread.start();
            this.addMessage("** Connected to " + this.serverAddress + ":" + this.serverPort + " **");
            if (this.username.length() > 0 && this.password.length() > 0) {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        DMobile.this.sendMessage("/login " + DMobile.this.username + " " + DMobile.this.password);
                    }
                }).start();
            }
            Thread autoSendThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    while (DMobile.this.running && DMobile.this.connected) {
                        try {
                            DMobile.this.sendMessage("/");
                            Thread.sleep(5000L);
                        }
                        catch (Exception exception) {}
                    }
                }
            });
            autoSendThread.start();
        }
        catch (Exception e) {
            this.addMessage("Error: " + e.getMessage());
        }
    }

    public void run() {
        byte[] buffer = new byte[512];
        while (this.running && this.connected) {
            try {
                int nl;
                int len = this.is.read(buffer);
                if (len <= 0) continue;
                String chunk = new String(buffer, 0, len, "UTF-8");
                this.recvBuffer.append(chunk);
                String bufStr = this.recvBuffer.toString();
                while ((nl = bufStr.indexOf(10)) != -1) {
                    String line = bufStr.substring(0, nl).trim();
                    if (!line.equals("*Ping!*") && line.length() > 0) {
                        this.addMessage(line);
                    }
                    bufStr = bufStr.substring(nl + 1);
                }
                this.recvBuffer.setLength(0);
                this.recvBuffer.append(bufStr);
            }
            catch (IOException e) {
                // empty catch block
                break;
            }
        }
        this.disconnect();
    }

    private void disconnect() {
        try {
            if (this.is != null) {
                this.is.close();
            }
            if (this.os != null) {
                this.os.close();
            }
            if (this.sc != null) {
                this.sc.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connected = false;
    }

    private void sendMessage(String msg) {
        try {
            byte[] data = msg.concat("\n").getBytes("UTF-8");
            this.os.write(data);
            this.os.flush();
        }
        catch (Exception e) {
            this.addMessage("Send error: " + e.getMessage());
        }
    }

    private void addMessage(String msg) {
        this.messages.addElement(new ChatMessage(msg));
        this.canvas.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSettings() {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)"DMconnectSettings", (boolean)true);
            RecordEnumeration re = rs.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                int id = re.nextRecordId();
                rs.deleteRecord(id);
            }
            re.destroy();
            String data = this.serverAddress + "|" + this.serverPort + "|" + this.username + "|" + this.password;
            rs.addRecord(data.getBytes(), 0, data.length());
        }
        catch (Exception e) {
            this.addMessage("Settings save error: " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettings() {
        block21: {
            RecordStore rs = null;
            try {
                rs = RecordStore.openRecordStore((String)"DMconnectSettings", (boolean)true);
                if (rs.getNumRecords() <= 0) break block21;
                RecordEnumeration re = rs.enumerateRecords(null, null, false);
                if (re.hasNextElement()) {
                    int id = re.nextRecordId();
                    byte[] record = rs.getRecord(id);
                    String data = new String(record);
                    String[] parts = new String[4];
                    int pos = 0;
                    for (int i = 0; i < 4; ++i) {
                        int next = data.indexOf(124, pos);
                        if (next == -1) {
                            next = data.length();
                        }
                        parts[i] = data.substring(pos, next);
                        pos = next + 1;
                    }
                    if (parts[0] != null) {
                        this.serverAddress = parts[0];
                    }
                    if (parts[1] != null) {
                        try {
                            this.serverPort = Integer.parseInt(parts[1]);
                        }
                        catch (NumberFormatException e) {
                            this.serverPort = 42439;
                        }
                    }
                    if (parts[2] != null) {
                        this.username = parts[2];
                    }
                    if (parts[3] != null) {
                        this.password = parts[3];
                    }
                }
                re.destroy();
            }
            catch (Exception e) {
                this.addMessage("Settings load error: " + e.getMessage());
            }
            finally {
                try {
                    if (rs != null) {
                        rs.closeRecordStore();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    class ChatCanvas
    extends Canvas {
        ChatCanvas() {
            this.setFullScreenMode(true);
        }

        protected void paint(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            int lineHeight = g.getFont().getHeight();
            g.setColor(0);
            g.fillRect(0, 0, w, h);
            g.setColor(65280);
            g.fillRect(0, 0, w, lineHeight + 4);
            g.setColor(0);
            g.drawString("Press FIRE to type", 2, 2, 20);
            int maxLines = (h - (lineHeight + 4)) / lineHeight;
            Vector<LinePart> wrappedLines = new Vector<LinePart>();
            for (int i = 0; i < DMobile.this.messages.size(); ++i) {
                ChatMessage cm = (ChatMessage)DMobile.this.messages.elementAt(i);
                int offset = 0;
                while (offset < cm.text.length()) {
                    int end;
                    for (end = offset; end < cm.text.length() && g.getFont().stringWidth(cm.text.substring(offset, end + 1)) <= w - 4; ++end) {
                    }
                    if (end == offset) {
                        ++end;
                    }
                    String line = cm.text.substring(offset, end);
                    wrappedLines.addElement(new LinePart(line, cm, offset, end));
                    offset = end;
                }
            }
            int start = Math.max(0, wrappedLines.size() - maxLines);
            int y = lineHeight + 6;
            for (int i = start; i < wrappedLines.size(); ++i) {
                LinePart lp = (LinePart)wrappedLines.elementAt(i);
                ChatMessage cm = lp.cm;
                if (cm.validNick) {
                    if (lp.end <= cm.colonIndex) {
                        this.drawNick(g, lp.text, y);
                    } else if (lp.offset <= cm.colonIndex && lp.end > cm.colonIndex) {
                        String nickPart = lp.text.substring(0, cm.colonIndex - lp.offset);
                        String restPart = lp.text.substring(cm.colonIndex - lp.offset);
                        this.drawNick(g, nickPart + ":", y);
                        int nickWidth = g.getFont().stringWidth(nickPart + ":");
                        g.setColor(0xFFFFFF);
                        g.drawString(restPart.length() > 1 ? restPart.substring(1) : "", 2 + nickWidth, y, 20);
                    } else {
                        g.setColor(0xFFFFFF);
                        g.drawString(lp.text, 2, y, 20);
                    }
                } else {
                    g.setColor(0xFFFFFF);
                    g.drawString(lp.text, 2, y, 20);
                }
                y += lineHeight;
            }
        }

        private void drawNick(Graphics g, String nickText, int y) {
            String nick = nickText.substring(0, nickText.length() - 1);
            if (nick.equals(DMobile.this.username)) {
                g.setColor(65535);
            } else {
                g.setColor(0xFF0000);
            }
            g.drawString(nickText, 2, y, 20);
        }

        protected void keyPressed(int keyCode) {
            if (this.getGameAction(keyCode) == 8) {
                DMobile.this.setCurrentScreen((Displayable)DMobile.this.inputBox);
            }
        }

        class LinePart {
            String text;
            ChatMessage cm;
            int offset;
            int end;

            LinePart(String text, ChatMessage cm, int offset, int end) {
                this.text = text;
                this.cm = cm;
                this.offset = offset;
                this.end = end;
            }
        }
    }

    class ChatMessage {
        String text;
        int colonIndex;
        boolean validNick;

        ChatMessage(String text) {
            String nickCandidate;
            this.text = text;
            this.colonIndex = text.indexOf(58);
            this.validNick = false;
            if (!text.startsWith("**") && this.colonIndex > 0 && (nickCandidate = text.substring(0, this.colonIndex)).indexOf(32) == -1) {
                this.validNick = true;
            }
        }
    }
}

